#!/usr/bin/gnuplot -persist
#
# Weergave van PM10 en PM2.5 luftdaten CSV informatie op grafiek gebaseerd op
# style van https://www.luchtmeetnet.nl/
#
# Rick van der Zwet <info@rickvanderzwet.nl>
#

# Graph annotation
set xdata time
set format x "%D\n%H:%M" timedate
set ylabel "{/Symbol m}g/m3" 
set title "Fijnstof concentraties, 2382 BW, Zoeterwoude"

# Graph formatting
set grid front lw 2
set terminal qt size 1920,1080
set key opaque

# Match CSV input format 
set timefmt "%Y/%m/%d %H:%M:%S"
set datafile separator ";"

# Plot entries
set xrange ["2019/12/31 18:00:00":"2020/01/03 00:00:00"]
set yrange [0:2100]
plot 	30   with filledcurves above y1=0   fs solid 1.00 lc rgb "#96C8FF" title "Goed (PM10)", \
	75   with filledcurves above y1=30  fs solid 1.00 lc rgb "#FFFFC8" title "Matig (PM10)", \
	100  with filledcurves above y1=75  fs solid 1.00 lc rgb "#FFC800" title "Onvoldoende (PM10)", \
	200  with filledcurves above y1=100 fs solid 1.00 lc rgb "#FF6464" title "Slecht (PM10)", \
	5000 with filledcurves above y1=200 fs solid 1.00 lc rgb "#C864FF" title "Zeer Slecht (PM10)", \
	'jaarwisseling-2019-2020.csv' every ::1 using 1:8 with lines lw 2 title "PM10", \
	'' using 1:9 with lines lw 2 title "PM2.5"
